﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System.IO;
using System.Reflection;
using System.ComponentModel;

namespace AZVIC.Ei8htPOS.POSRetail.NETS
{
    /// <summary>
    /// Interaction logic for OCBCTerminal.xaml
    /// </summary>
    public partial class NETSTerminal : Window
    {
        #region Internal Variables
        private SerialPort comPort = new SerialPort();
        public string ReturnMessage = string.Empty, RequestMessage = string.Empty, ResponseMessage = string.Empty;
        int ExecCount = 0;
        bool ReceivedAck = false;
        bool ResponseReceived = false;
        System.Windows.Forms.Timer WindowTimer;
        NETSHelper.TransactionType CurrentType;
        private decimal _Amount = 0;
        #endregion

        public NETSTerminal(decimal Amount)
        {
            InitializeComponent();
            ClosePort();
            _Amount = Amount;
            WindowTimer = new System.Windows.Forms.Timer();

        }

        private void window_closing(object sender, CancelEventArgs e)
        {
            try
            {
                this.Dispatcher.BeginInvoke((Action)(() => this.comPort.Close()));
            }
            catch (Exception ex)
            {

            }

        }

        #region Timer Events

        public void InitTimer()
        {
            WindowTimer = new System.Windows.Forms.Timer();
            WindowTimer.Tick += new EventHandler(timer1_Tick);
            WindowTimer.Interval = AppSession.NETSTimeout; // in milliseconds
            WindowTimer.Start();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            if ((!ResponseReceived) && ExecCount < 3)
            {
                ExecCount++;
                SendRequest(CurrentType);
            }
            else if (ExecCount >= 3)
            {
                WindowTimer.Tick -= timer1_Tick;
                if (!ResponseReceived)
                {
                    App.ShowErrorMessageBox("Request Timed Out. Please try again", "Ei8ht POS");
                    ClosePort();
                    btnManual.Dispatcher.BeginInvoke((Action)(() => btnManual.IsEnabled = true));
                    btnPay.Dispatcher.BeginInvoke((Action)(() => btnPay.IsEnabled = true));
                    ExecCount = 0; ReturnMessage = string.Empty; ReceivedAck = false; ResponseReceived = false;
                }
            }
            else
            {
                return;
            }
        }

        #endregion

        #region Event Handlers

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                ClosePort();
                this.Tag = false;
                this.Close();
            }
            catch (Exception ex)
            {
                App.ShowErrorMessageBox("Transaction Failed! Please try again", "Ei8ht POS");
                this.Dispatcher.BeginInvoke((Action)(() => this.Close()));
            }
        }

        private void btnPay_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                btnPay.Dispatcher.BeginInvoke((Action)(() => btnPay.IsEnabled = false));
                btnManual.Dispatcher.BeginInvoke((Action)(() => btnManual.IsEnabled = false));
                OpenPort();
                if (rbContactless.IsChecked.Value)
                    CurrentType = NETSHelper.TransactionType.ContactLess;
                else
                    CurrentType = NETSHelper.TransactionType.SalesPayment;
                SendRequest(CurrentType);

            }
            catch (Exception ex)
            {
                btnManual.IsEnabled = true;
                SaveTerminalLogToFile<Exception>(ex);
                App.ShowErrorMessageBox(ex.Message, "Ei8ht POS");
                this.Dispatcher.BeginInvoke((Action)(() => this.comPort.Close()));
            }
            finally
            {
                InitTimer();
            }
        }

        private void btnTapClick(object sender, RoutedEventArgs e)
        {
            rbContactless.IsChecked = true;
            rbNormalSales.IsChecked = false;
        }

        private void btnNormalClick(object sender, RoutedEventArgs e)
        {
            rbNormalSales.IsChecked = true;
            rbContactless.IsChecked = false;
        }

        #endregion

        #region Port - Send & Receive

        #region comPort_DataReceived
        /// <summary>
        /// method that will be called when theres data waiting in the buffer
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>

        private void comPort_DataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            try
            {
                //if (!comPort.IsOpen)
                //    OpenPort();
                //if (comPort.IsOpen)
                //{
                int bytes = comPort.BytesToRead;
                byte[] comBuffer = new byte[bytes];
                comPort.Read(comBuffer, 0, bytes);
                DisplayData(NETSHelper.MessageType.Incoming, ByteToHex(comBuffer));
                //}
            }
            catch (Exception ex)
            {
                this.Dispatcher.BeginInvoke((Action)(() => this.comPort.Close()));
            }
        }
        #endregion

        #region Send Ack, Nack, Write To Port
        public string WriteData(string msg)
        {
            try
            {
                byte[] newMsg = HexToByte(msg);
                if (!comPort.IsOpen)
                    OpenPort();
                comPort.Write(newMsg, 0, newMsg.Length);
                //DisplayData(NETSHelper.MessageType.Outgoing, ByteToHex(newMsg));
            }
            catch (Exception ex)
            {
                //App.ShowErrorMessageBox(ex.Message, "Ei8ht POS");// txtDisplayWindow.Dispatcher.BeginInvoke((Action)(() => txtDisplayWindow.Text+= Environment.NewLine + ex.Message));
                App.ShowErrorMessageBox("Transaction Failed! Please try again", "Ei8ht POS");
                this.Dispatcher.BeginInvoke((Action)(() => this.Close()));
            }

            return this.ReturnMessage;
        }

        private void SendAcknowledgement()
        {
            this.WriteData("06");
        }

        private void SendNegativeAcknowledgement()
        {
            this.WriteData("15");
        }

        #endregion

        #region DisplayData
        /// <summary>
        /// method to display the data to & from the port
        /// on the screen
        /// </summary>
        /// <param name="type">MessageType of the message</param>
        /// <param name="msg">Message to display</param>
        private void DisplayData(NETSHelper.MessageType type, string msg)
        {
            try
            {
                if (ExecCount < 3)
                {
                    ReturnMessage += msg;
                    WindowTimer.Tick -= timer1_Tick;
                    if (type == NETSHelper.MessageType.Incoming)
                    {
                        ResponseReceived = true;
                        if (!ReceivedAck && (msg.Contains(StringValueAttribute.GetStringValue(NETSHelper.ControlCharacter.Acknowledge)) || msg.Contains(StringValueAttribute.GetStringValue(NETSHelper.ControlCharacter.NegativeAcknowledge))))
                        {
                            if (msg.Contains(StringValueAttribute.GetStringValue(NETSHelper.ControlCharacter.Acknowledge)))
                            {
                                ReceivedAck = true;
                                ResponseMessage = string.Empty;
                            }
                            else if (msg.Contains(StringValueAttribute.GetStringValue(NETSHelper.ControlCharacter.NegativeAcknowledge)))
                            {
                                ResponseReceived = false;
                                SendRequest(CurrentType);
                                WindowTimer.Tick += timer1_Tick;
                                ExecCount++;
                                ResponseMessage = string.Empty;
                                //ReceivedAck = false;
                            }
                        }
                        else if (ReceivedAck)
                        {
                            bool IsEndOfMessage = false;
                            IsEndOfMessage = (msg.IndexOf("03") != -1);
                            if (IsEndOfMessage)
                            {
                                if (ResponseMessage.Length <= 10)
                                {
                                    IsEndOfMessage = false;
                                }
                            }
                            //TO avoid confusing length field BCD value 03 as End of Text
                            if (!IsEndOfMessage)
                            {
                                ResponseMessage += msg;
                            }
                            else
                            {
                                ResponseMessage += msg;
                                string LRC = ResponseMessage.Substring(ResponseMessage.LastIndexOf("03") + 3, 2);
                                //ResponseMessage = ResponseMessage.Substring(0, ResponseMessage.IndexOf(StringValueAttribute.GetStringValue(NETSHelper.TwoStepProtocol.EndOfText)) + 1);
                                string LRCMessage = ResponseMessage.Substring(3, ResponseMessage.Length - 3);
                                LRCMessage = LRCMessage.Substring(0, LRCMessage.LastIndexOf("03") + 2);

                                string ComputedLRC = NETSHelper.CalculateLongitudinalRedundancyCheck(LRCMessage.Trim()).ToString().PadLeft(2, '0');
                                if (LRC.Equals(ComputedLRC))
                                {
                                    //Transaction Success
                                    //Send Ack
                                    SendAcknowledgement();
                                    AssimilateMessage(ResponseMessage);
                                    ClosePort();
                                    WindowTimer.Tick -= timer1_Tick;
                                }
                                else
                                {
                                    //Message Corrupted, Send NACK
                                    SendNegativeAcknowledgement();
                                    ResponseMessage = string.Empty;
                                    WindowTimer.Tick += timer1_Tick;
                                }
                            }
                        }
                    }
                }
                else
                {
                    //SaveTerminalLogToFile<Exception>(ex);
                    App.ShowErrorMessageBox("Transaction Declined - Exceeded Max. Number of attempts.", "Ei8ht POS");
                    ClosePort();
                    btnPay.Dispatcher.BeginInvoke((Action)(() => btnPay.IsEnabled = true));
                    btnManual.Dispatcher.BeginInvoke((Action)(() => btnManual.IsEnabled = true));
                    return;
                }
            }

            catch (Exception ex)
            {
                SaveTerminalLogToFile<Exception>(ex);
                //App.ShowErrorMessageBox("Transaction Declined - " + ex.Message, "Ei8ht POS");
                btnManual.IsEnabled = true;
                ClosePort();
                App.ShowErrorMessageBox("Transaction Failed! Please try again", "Ei8ht POS");
                this.Dispatcher.BeginInvoke((Action)(() => this.Close()));
            }
            finally
            {
                //btnPay.Dispatcher.BeginInvoke((Action)(() => btnPay.IsEnabled = true));
            }
        }

        private void AssimilateMessage(string ResponseMessage)
        {
            NETSHelper.TransactionResponse response = new NETSHelper.TransactionResponse() { DeviceRequest = RequestMessage, DeviceResponse = ResponseMessage };
            response.ProcessResponseString();

            if (response.IsApproved)
            {
                AppSession.CurrentNETSTransaction = response;
                //txtDisplayWindow.Dispatcher.BeginInvoke((Action)(() => txtDisplayWindow.Text += Environment.NewLine + "Transaction Successful"));
                this.Dispatcher.BeginInvoke((Action)(() => this.Tag = true));
                this.Dispatcher.BeginInvoke((Action)(() => this.Close()));
            }
            else
            {
                App.ShowErrorMessageBox("Transaction Declined " + response.ResponseText, "Ei8ht POS");
                btnPay.Dispatcher.BeginInvoke((Action)(() => btnPay.IsEnabled = true));
                btnManual.Dispatcher.BeginInvoke((Action)(() => btnManual.IsEnabled = true));
            }

            ReturnMessage = string.Empty;
            ResponseMessage = string.Empty;
            ExecCount = 0;
            ReceivedAck = false;
            ResponseReceived = false;
            ClosePort();
        }

        private void SaveTerminalLogToFile<T>(T LogMessage)
        {
            using (StreamWriter w = File.AppendText(System.IO.Path.GetTempPath() + "NETSlog_" + DateTime.Now.ToString("yyyyMMdd") + ".txt"))
            {
                Type _type = typeof(T);
                string _log = "";
                if (_type == typeof(Exception))
                {
                    foreach (PropertyInfo pi in typeof(Exception).GetProperties())
                    {
                        _log += string.Format("{0} - {1}{2}", pi.Name, pi.GetValue(LogMessage), Environment.NewLine);
                    }
                }
                else
                {
                    _log = LogMessage.ToString();
                }

                w.WriteLine(LogMessage);
            }
        }

        #endregion

        #endregion

        #region Byte Hex Conversion

        #region HexToByte
        /// <summary>
        /// method to convert hex string into a byte array
        /// </summary>
        /// <param name="msg">string to convert</param>
        /// <returns>a byte array</returns>
        public byte[] HexToByte(string msg)
        {
            byte[] comBuffer = new byte[2];
            try
            {
                msg = msg.Replace(" ", "");
                comBuffer = new byte[msg.Length / 2];
                for (int i = 0; i < msg.Length; i += 2)
                    comBuffer[i / 2] = (byte)Convert.ToByte(msg.Substring(i, 2), 16);

            }
            catch (Exception ex)
            {
                App.ShowErrorMessageBox("Transaction Failed! Please try again", "Ei8ht POS");
                this.Dispatcher.BeginInvoke((Action)(() => this.Close()));
            }
            return comBuffer;
        }
        #endregion

        #region ByteToHex
        /// <summary>
        /// method to convert a byte array into a hex string
        /// </summary>
        /// <param name="comByte">byte array to convert</param>
        /// <returns>a hex string</returns>
        public string ByteToHex(byte[] comByte)
        {
            StringBuilder builder = new StringBuilder();
            try
            {
                builder = new StringBuilder(comByte.Length * 3);
                foreach (byte data in comByte)
                    builder.Append(Convert.ToString(data, 16).PadLeft(2, '0').PadRight(3, ' '));
            }
            catch (Exception ex)
            {
                App.ShowErrorMessageBox("Transaction Failed! Please try again", "Ei8ht POS");
                this.Dispatcher.BeginInvoke((Action)(() => this.Close()));
            }
            return builder.ToString().ToUpper();
        }
        #endregion

        #endregion

        #region Open , Send Request & Close Port
        public bool OpenPort()
        {
            try
            {
                if (comPort.IsOpen)
                    comPort.Close();
                comPort.BaudRate = int.Parse(AppSession.NETSTerminalBaudRate);
                comPort.DataBits = int.Parse(AppSession.NETSTerminalDataBits);
                comPort.StopBits = (StopBits)Enum.Parse(typeof(StopBits), AppSession.NETSTerminalStopBits);
                comPort.Parity = (Parity)Enum.Parse(typeof(Parity), AppSession.NETSTerminalParity);
                comPort.PortName = AppSession.NETSTerminalPortName;
                comPort.Handshake = Handshake.None;
                comPort.ReadTimeout = 2000;
                comPort.WriteTimeout = 2000;
                //now open the port
                comPort.Open();
                comPort.DataReceived += new System.IO.Ports.SerialDataReceivedEventHandler(comPort_DataReceived);
                return true;
            }
            catch (Exception ex)
            {
                SaveTerminalLogToFile<Exception>(ex);
                App.ShowErrorMessageBox("Error in communicating to terminal - " + ex.Message, "Ei8ht POS");

                //txtDisplayWindow.Dispatcher.BeginInvoke((Action)(() => txtDisplayWindow.Text += Environment.NewLine + "Transaction Declined -" +ex.Message));
                btnManual.IsEnabled = true;
                return false;
            }
        }

        private void SendRequest(NETSHelper.TransactionType ttype)
        {
            NETSHelper.TransactionRequest request = new NETSHelper.TransactionRequest()
            {
                TransactionType = ttype,
                ReceiptNumber = AppSession.CurrentOrders.OrderNumber,
                Amount = _Amount,
                Currency = "SGD"
            };
            RequestMessage = request.ToString();
            string returnValue = WriteData(RequestMessage);
            //this.Dispatcher.BeginInvoke((Action)(() => this.comPort.Close()));
        }

        public bool ClosePort()
        {
            try
            {
                if (this.comPort.IsOpen == true) comPort.Close();
                return true;
            }
            catch (Exception ex)
            {
                DisplayData(NETSHelper.MessageType.Error, ex.Message);
                return false;
            }
        }
        #endregion

        private void btnManual_Click_1(object sender, RoutedEventArgs e)
        {
            btnOK.Dispatcher.BeginInvoke((Action)(() => btnOK.IsEnabled = true));
            btnPay.Dispatcher.BeginInvoke((Action)(() => btnPay.IsEnabled = false));
            txtReferenceNumber.BorderThickness = new Thickness(1);
            txtReferenceNumber.BorderBrush = Brushes.Red;

        }

        private void btnOK_Click_1(object sender, RoutedEventArgs e)
        {
            if (string.IsNullOrEmpty(txtReferenceNumber.Text))
            {
                App.ShowMessageBox("Please enter Reference Number once the transaction is complete", "Ei8ht POS");
                return;
            }

            NETSHelper.TransactionResponse response = new NETSHelper.TransactionResponse()
            {
                UniqueID = Guid.NewGuid(),
                IsActive = true,
                AdminUserAccountID = AppSession.CurrentAdminUser.UniqueID,
                DeviceRequest = "Manual Request",
                DeviceResponse = string.Empty,
                IsApproved = true,
                TDTransactionAmount = _Amount,
                ResponseType = NETSHelper.TransactionType.ContactLess,
                BatchNumber = txtReferenceNumber.Text.Trim()
            };
            AppSession.CurrentNETSTransaction = response;
            this.Tag = true;
            this.Close();
            ClosePort();
        }

    }
}
